<?php

/** @var yii\web\View $this */

use yii\bootstrap5\Html;
use yii\helpers\Url;

$this->title = 'My Yii Application';
?>
<div class="site-index">

    <div class="jumbotron text-center bg-transparent mt-5 mb-5">
        <div class="d-flex justify-content-center flex-column align-items-center">
            <h1 class="display-4">Добро пожаловать в отдел кадров!</h1>
            <a class="btn btn-primary text-decoration-none w-100" href="<?= Url::toRoute(['site/application']); ?>">Подать
                анкету</a>
        </div>

        <!-- Карусель с фиксированной высотой -->
        <div id="carouselExampleControls" class="carousel slide mt-4" data-bs-ride="carousel" style="max-width: 800px; margin: 0 auto;">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <?= Html::img('@web/images/1.png', [
                        'alt' => 'My logo',
                        'class' => 'd-block w-100 carousel-image',
                        'style' => 'object-fit: cover; height: 400px;'
                    ]) ?>
                </div>
                <div class="carousel-item">
                    <?= Html::img('@web/images/2.jpg', [
                        'alt' => 'My logo',
                        'class' => 'd-block w-100 carousel-image',
                        'style' => 'object-fit: cover; height: 400px;'
                    ]) ?>
                </div>
                <div class="carousel-item">
                    <?= Html::img('@web/images/3.jpg', [
                        'alt' => 'My logo',
                        'class' => 'd-block w-100 carousel-image',
                        'style' => 'object-fit: cover; height: 400px;'
                    ]) ?>
                </div>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls"
                    data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls"
                    data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
        </div>
    </div>
</div>

<style>
    .carousel-image {
        object-fit: cover;
        height: 400px;
        width: 100%;
    }

    /* Адаптивность для мобильных устройств */
    @media (max-width: 768px) {
        .carousel-image {
            height: 300px;
        }
    }

    @media (max-width: 576px) {
        .carousel-image {
            height: 250px;
        }
    }
</style>