<?php

namespace app\modules\kabinet\controllers;

use app\models\PasswordChangeForm;
use app\models\User;
use Yii;
use yii\web\Controller;
use app\models\Application;

class DefaultController extends Controller
{
    public function actionIndex()
    {
        $userId = Yii::$app->user->id;
        $applications = Application::find()
            ->where(['user_id' => $userId])
            ->all();

        return $this->render('index', [
            'applications' => $applications,
        ]);
    }

    public function actionUpdate($id)
    {
        $application = Application::findOne($id);

        if (!$application || $application->user_id != Yii::$app->user->id) {
            throw new \yii\web\ForbiddenHttpException('Доступ запрещен');
        }

        if ($application->load(Yii::$app->request->post()) && $application->save()) {
            Yii::$app->session->setFlash('success', 'Заявка успешно обновлена');
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'application' => $application,
        ]);
    }

    public function actionUpdateemail()
    {
        $model = new \app\models\ProfileUpdateForm();
        $model->user = Yii::$app->user->identity;

        if ($model->user === null) {
            return $this->redirect(['site/login']);
        }

        $model->email = $model->user->email;

        if ($model->load(Yii::$app->request->post()) && $model->update()) {
            Yii::$app->session->setFlash('success', 'Email успешно изменен');
            return $this->redirect(['index']);
        }

        return $this->render('updateemail', [
            'model' => $model,
        ]);
    }

    public function actionPass()
    {
        $user = User::findOne(Yii::$app->user->identity->getId());
        $model = new PasswordChangeForm();

        if ($model->load(Yii::$app->request->post())) {
            if ($model->validate() && $user->validatePassword($model->oldPassword)) {
                if ($model->changePassword()) {
                    Yii::$app->session->setFlash('success', 'Пароль успешно обновлен');
                    return $this->redirect(['index']);
                }
            }
        }

        return $this->render('pass', ['model' => $model]);
    }
}



