<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Application;

/**
 * ApplicationSearch represents the model behind the search form of `app\models\Application`.
 */
class ApplicationSearch extends Application
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'user_id'], 'integer'],
            [['surname', 'name', 'patronymic', 'photo', 'date_birthday', 'gender', 'country', 'passport', 'education', 'education_organization', 'special_qual', 'diplom', 'scan_diplom', 'snils', 'place_work', 'post', 'work_experience', 'health', 'phone_number', 'email', 'extra_info'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     * @param string|null $formName Form name to be used into `->load()` method.
     *
     * @return ActiveDataProvider
     */
    public function search($params, $formName = null)
    {
        $query = Application::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params, $formName);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'date_birthday' => $this->date_birthday,
            'user_id' => $this->user_id,
        ]);

        $query->andFilterWhere(['like', 'surname', $this->surname])
            ->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'patronymic', $this->patronymic])
            ->andFilterWhere(['like', 'photo', $this->photo])
            ->andFilterWhere(['like', 'gender', $this->gender])
            ->andFilterWhere(['like', 'country', $this->country])
            ->andFilterWhere(['like', 'passport', $this->passport])
            ->andFilterWhere(['like', 'education', $this->education])
            ->andFilterWhere(['like', 'education_organization', $this->education_organization])
            ->andFilterWhere(['like', 'special_qual', $this->special_qual])
            ->andFilterWhere(['like', 'diplom', $this->diplom])
            ->andFilterWhere(['like', 'scan_diplom', $this->scan_diplom])
            ->andFilterWhere(['like', 'snils', $this->snils])
            ->andFilterWhere(['like', 'place_work', $this->place_work])
            ->andFilterWhere(['like', 'post', $this->post])
            ->andFilterWhere(['like', 'work_experience', $this->work_experience])
            ->andFilterWhere(['like', 'health', $this->health])
            ->andFilterWhere(['like', 'phone_number', $this->phone_number])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'extra_info', $this->extra_info]);

        return $dataProvider;
    }
}
