<?php

namespace app\controllers;

use app\models\Application;
use app\models\SignupForm;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\LoginForm;
use app\models\ContactForm;
use yii\web\UploadedFile;

class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
        return $this->render('index');
    }

    /**
     * Login action.
     *
     * @return Response|string
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        }

        $model->password = '';
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    /**
     * Logout action.
     *
     * @return Response
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    /**
     * Displays contact page.
     *
     * @return Response|string
     */
    public function actionContact()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->contact(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('contactFormSubmitted');

            return $this->refresh();
        }
        return $this->render('contact', [
            'model' => $model,
        ]);
    }

    /**
     * Displays about page.
     *
     * @return string
     */
    public function actionAbout()
    {
        return $this->render('about');
    }

    public function actionSignup()
    {
        $model = new SignupForm();
        if ($model->load(Yii::$app->request->post()) && $model->signup()) {
            Yii::$app->session->setFlash('success', 'Вы успешно прошли регистрацию!');
            return $this->goHome();
        }
        return $this->render('signup', [
            'model' => $model,
        ]);
    }


    public function actionApplication()
    {
        if (Yii::$app->user->isGuest) {
            return $this->redirect(['site/login']);
        }

        $model = Application::findOne(['user_id' => Yii::$app->user->id]);

        if (!$model) {
            $model = new Application();
            $model->user_id = Yii::$app->user->id;

            $user = Yii::$app->user->identity;

            if (isset($user->surname)) $model->surname = $user->surname;
            if (isset($user->name)) $model->name = $user->name;
            if (isset($user->patronymic)) $model->patronymic = $user->patronymic;
            if (isset($user->email)) $model->email = $user->email;
            if (isset($user->phone_number)) $model->phone_number = $user->phone_number;

        }

        if ($model->load(Yii::$app->request->post())) {
            $photoFile = \yii\web\UploadedFile::getInstance($model, 'photo');
            $passportFiles = \yii\web\UploadedFile::getInstances($model, 'passportFiles');

            if ($model->save()) {
                if ($photoFile) {
                    $fileName = 'photo_' . $model->user_id . '_' . time() . '.' . $photoFile->extension;
                    if ($photoFile->saveAs('uploads/' . $fileName)) {
                        $model->photo = $fileName;
                        $model->save(false);
                    }
                }
                if ($passportFiles) {
                    $savedFiles = [];

                    if (!empty($model->passport)) {
                        $savedFiles = explode('|', $model->passport);
                    }

                    foreach ($passportFiles as $file) {
                        $fileName = 'passport_' . $model->user_id . '_' . time() . '_' . $file->baseName . '.' . $file->extension;
                        if ($file->saveAs('uploads/' . $fileName)) {
                            $savedFiles[] = $fileName;
                        }
                    }

                    $model->passport = implode('|', $savedFiles);
                    $model->save(false);
                }

                Yii::$app->session->setFlash('success', 'Анкета успешно сохранена!');
                return $this->refresh();
            }
        }

        return $this->render('application', [
            'model' => $model,
        ]);
    }
}
